<?php

namespace App\Controllers;

use App\Models\Content;
use App\Models\Menu;

class PageController extends BaseController
{
    /**
     * Laad pagina content als het in de database staat
     */
    private function getContent(string $slug): array
    {
        $sections = Content::getAllForPage($slug);
        $data = [];
        foreach ($sections as $s) {
            $data[$s['sectie']] = $s;
        }
        return $data;
    }

    public function home(): void
    {
        $content = $this->getContent('home');
        
        // Fetch active bulletins
        $bulletins = $this->db->fetchAll(
            "SELECT * FROM bulletins WHERE actief = 1 AND 
             (verloopdatum IS NULL OR verloopdatum >= CURDATE()) 
             ORDER BY prioriteit DESC, created_at DESC LIMIT 5"
        );

        // Fetch upcoming activities
        $activiteiten = $this->db->fetchAll(
            "SELECT * FROM activiteiten WHERE datum >= CURDATE() 
             ORDER BY datum ASC LIMIT 5"
        );

        // Fetch available gardens
        $beschikbareTuinen = $this->db->fetch(
            "SELECT COUNT(*) as count FROM tuinen WHERE status = 'beschikbaar'"
        );

        // Fetch calamity notification if any
        $calamiteit = $this->db->fetch(
            "SELECT * FROM meldingen_systeem WHERE type = 'calamiteit' AND actief = 1 
             ORDER BY created_at DESC LIMIT 1"
        );

        $this->render('public/home', [
            'title' => 'Welkom bij VTV De Beukhoeve',
            'content' => $content,
            'bulletins' => $bulletins,
            'activiteiten' => $activiteiten,
            'beschikbare_tuinen' => $beschikbareTuinen['count'] ?? 0,
            'calamiteit' => $calamiteit,
        ]);
    }

    public function overOns(): void
    {
        $this->render('public/over-ons', [
            'title' => 'Wie zijn wij - VTV De Beukhoeve',
            'content' => $this->getContent('over-ons'),
        ]);
    }

    public function bestuur(): void
    {
        $bestuur = $this->db->fetchAll(
            "SELECT u.voornaam, u.achternaam, bf.functie, bf.beschrijving, bf.foto
             FROM bestuur_functies bf 
             LEFT JOIN users u ON bf.user_id = u.id 
             WHERE bf.actief = 1 
             ORDER BY bf.volgorde"
        );

        $this->render('public/bestuur', [
            'title' => 'Bestuur - VTV De Beukhoeve',
            'content' => $this->getContent('bestuur'),
            'bestuur' => $bestuur,
        ]);
    }

    public function commissies(): void
    {
        $commissies = $this->db->fetchAll(
            "SELECT * FROM commissies WHERE actief = 1 ORDER BY naam"
        );

        $this->render('public/commissies', [
            'title' => 'Commissies - VTV De Beukhoeve',
            'content' => $this->getContent('commissies'),
            'commissies' => $commissies,
        ]);
    }

    public function faciliteiten(): void
    {
        $this->render('public/faciliteiten', [
            'title' => 'Faciliteiten - VTV De Beukhoeve',
            'content' => $this->getContent('faciliteiten'),
        ]);
    }

    public function plattegrond(): void
    {
        $this->render('public/plattegrond', [
            'title' => 'Plattegrond - VTV De Beukhoeve',
            'content' => $this->getContent('plattegrond'),
        ]);
    }

    public function beschikbareTuinen(): void
    {
        $tuinen = $this->db->fetchAll(
            "SELECT * FROM tuinen WHERE status = 'beschikbaar' ORDER BY tuinnummer"
        );

        $this->render('public/beschikbare-tuinen', [
            'title' => 'Beschikbare Tuinen - VTV De Beukhoeve',
            'content' => $this->getContent('beschikbare-tuinen'),
            'tuinen' => $tuinen,
        ]);
    }

    public function contact(): void
    {
        $this->render('public/contact', [
            'title' => 'Contact - VTV De Beukhoeve',
            'content' => $this->getContent('contact'),
        ]);
    }

    public function aspirantInfo(): void
    {
        $this->render('public/aspirant-info', [
            'title' => 'Ik wil een tuin - VTV De Beukhoeve',
            'content' => $this->getContent('aspirant-info'),
        ]);
    }
}
