<?php
$dbContent = $content['body']['inhoud'] ?? '';
if ($dbContent): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="prose prose-lg max-w-none bg-white rounded-xl shadow-sm border border-gray-100 p-8">
        <?= $dbContent ?>
    </div>
</section>
<?php else: ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <h1 class="text-3xl font-bold text-gray-900 mb-2">Wie zijn wij</h1>
    <p class="text-gray-500 mb-10 max-w-3xl">Leer meer over VTV De Beukhoeve en waar wij voor staan.</p>

    <div class="prose prose-lg max-w-none">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-8 mb-8">
            <h2 class="text-xl font-semibold text-gray-900 mb-4">Onze vereniging</h2>
            <p class="text-gray-600 leading-relaxed">
                VTV De Beukhoeve is een volkstuinvereniging waar gemeenschap en groen samenkomen. 
                Onze leden genieten van hun eigen stukje natuur in de stad, waar ze tuinieren, 
                ontspannen en samen activiteiten organiseren.
            </p>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-8 mb-8">
            <h2 class="text-xl font-semibold text-gray-900 mb-4">Waar staan wij voor</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-6">
                <div class="text-center p-4">
                    <span class="text-4xl block mb-3">🌿</span>
                    <h3 class="font-semibold text-gray-900 mb-2">Groen & Duurzaam</h3>
                    <p class="text-sm text-gray-600">Wij streven naar een duurzame en groene omgeving voor alle leden.</p>
                </div>
                <div class="text-center p-4">
                    <span class="text-4xl block mb-3">🤝</span>
                    <h3 class="font-semibold text-gray-900 mb-2">Gemeenschap</h3>
                    <p class="text-sm text-gray-600">Samen maken we er iets moois van. Samenwerken staat centraal.</p>
                </div>
                <div class="text-center p-4">
                    <span class="text-4xl block mb-3">🏡</span>
                    <h3 class="font-semibold text-gray-900 mb-2">Rust & Ontspanning</h3>
                    <p class="text-sm text-gray-600">Een oase van rust midden in de stad.</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-8">
            <h2 class="text-xl font-semibold text-gray-900 mb-4">Geschiedenis</h2>
            <p class="text-gray-600 leading-relaxed">
                De Beukhoeve heeft een rijke geschiedenis die teruggaat tot... 
                <!-- Content kan later via CMS worden beheerd -->
            </p>
        </div>
    </div>
</section>
<?php endif; ?>
