<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Mijn inspecties</h1>
    <a href="<?= url('/portaal/inspecties/start') ?>" class="px-4 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700">
        🔍 Inspectie starten
    </a>
</div>

<div class="bg-white rounded-xl border overflow-hidden">
    <table class="w-full">
        <thead class="bg-gray-50 border-b"><tr>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Tuin</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Datum</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Status</th>
            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Resultaat</th>
            <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase"></th>
        </tr></thead>
        <tbody class="divide-y">
            <?php if (empty($inspecties)): ?>
            <tr><td colspan="5" class="px-4 py-8 text-center text-gray-400">Nog geen inspecties uitgevoerd</td></tr>
            <?php endif; ?>
            <?php foreach ($inspecties as $i): ?>
            <tr class="hover:bg-gray-50">
                <td class="px-4 py-3 text-sm font-bold text-groen-700"><?= e($i['tuinnummer']) ?></td>
                <td class="px-4 py-3 text-sm text-gray-500"><?= date('d-m-Y H:i', strtotime($i['gestart_op'])) ?></td>
                <td class="px-4 py-3">
                    <?php if ($i['status'] === 'gestart'): ?>
                    <span class="text-xs px-2 py-1 rounded-full bg-yellow-100 text-yellow-700">Lopend</span>
                    <?php else: ?>
                    <span class="text-xs px-2 py-1 rounded-full bg-groen-100 text-groen-700">Afgerond</span>
                    <?php endif; ?>
                </td>
                <td class="px-4 py-3">
                    <?php if ($i['weigert_medewerking']): ?>
                    <span class="text-xs text-red-600 font-bold">⛔ Weigering</span>
                    <?php elseif ($i['eindstatus']): ?>
                    <?php $kl = ['groen'=>'bg-green-100 text-green-700','oranje'=>'bg-orange-100 text-orange-700','rood'=>'bg-red-100 text-red-700']; ?>
                    <span class="text-xs px-2 py-1 rounded <?= $kl[$i['eindstatus']] ?? '' ?>"><?= ucfirst($i['eindstatus']) ?></span>
                    <?php else: ?>—<?php endif; ?>
                </td>
                <td class="px-4 py-3 text-right">
                    <?php if ($i['status'] === 'gestart'): ?>
                    <a href="<?= url('/portaal/inspecties/' . $i['id'] . '/checklist') ?>" class="text-sm text-blue-600 font-medium">Checklist →</a>
                    <?php else: ?>
                    <a href="<?= url('/portaal/inspecties/' . $i['id']) ?>" class="text-sm text-blue-600">Details</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
