<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($title ?? 'Ledenportaal - VTV De Beukhoeve') ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'groen': {
                            50: '#f0fdf4', 100: '#dcfce7', 200: '#bbf7d0',
                            300: '#86efac', 400: '#4ade80', 500: '#22c55e',
                            600: '#16a34a', 700: '#15803d', 800: '#166534', 900: '#14532d',
                        }
                    }
                }
            }
        }
    </script>
    <style>[x-cloak] { display: none !important; }</style>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="min-h-screen bg-gray-100" x-data="{ sidebarOpen: false }">

    <!-- Top bar -->
    <header class="bg-white shadow-sm border-b border-gray-200 fixed top-0 left-0 right-0 z-30">
        <div class="flex justify-between items-center h-16 px-4 sm:px-6">
            <div class="flex items-center space-x-4">
                <button @click="sidebarOpen = !sidebarOpen" class="lg:hidden p-2 rounded-md text-gray-500 hover:bg-gray-100">
                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/></svg>
                </button>
                <a href="<?= url('/') ?>" class="flex items-center space-x-2">
                    <div class="w-8 h-8 bg-groen-600 rounded-lg flex items-center justify-center">
                        <svg class="w-5 h-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/></svg>
                    </div>
                    <span class="text-lg font-bold text-groen-800">De Beukhoeve</span>
                </a>
            </div>
            
            <div class="flex items-center space-x-4">
                <!-- Notifications -->
                <a href="<?= url('/portaal/notificaties') ?>" class="relative p-2 text-gray-500 hover:text-gray-700 hover:bg-gray-100 rounded-full">
                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/></svg>
                    <?php if (($ongelezen_berichten ?? 0) > 0): ?>
                    <span class="absolute top-0 right-0 w-5 h-5 bg-red-500 text-white text-xs rounded-full flex items-center justify-center"><?= $ongelezen_berichten ?></span>
                    <?php endif; ?>
                </a>
                
                <!-- User menu -->
                <div class="relative" x-data="{ open: false }">
                    <button @click="open = !open" class="flex items-center space-x-2 px-3 py-2 rounded-lg hover:bg-gray-100">
                        <div class="w-8 h-8 bg-groen-100 text-groen-700 rounded-full flex items-center justify-center font-semibold text-sm">
                            <?= strtoupper(substr($auth['user']['naam'] ?? 'U', 0, 1)) ?>
                        </div>
                        <span class="hidden sm:block text-sm font-medium text-gray-700"><?= e($auth['user']['naam'] ?? '') ?></span>
                    </button>
                    <div x-show="open" x-cloak @click.away="open = false" x-transition
                         class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg border border-gray-100 py-1 z-50">
                        <a href="<?= url('/portaal/profiel') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">Mijn profiel</a>
                        <a href="<?= url('/') ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-50">Naar website</a>
                        <?php if (in_array(strtolower($auth['user']['role'] ?? ''), ['superuser', 'bestuur', 'penningmeester', 'pagina_beheer'])): ?>
                        <a href="<?= url('/admin') ?>" class="block px-4 py-2 text-sm text-blue-600 hover:bg-blue-50">Beheerpaneel</a>
                        <?php endif; ?>
                        <hr class="my-1">
                        <a href="<?= url('/logout') ?>" class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50">Uitloggen</a>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Sidebar -->
    <aside class="fixed top-16 left-0 bottom-0 w-64 bg-white border-r border-gray-200 z-20 overflow-y-auto
                  transform transition-transform duration-200 ease-in-out
                  lg:translate-x-0"
           :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'">
        <nav class="px-4 py-6 space-y-1">
            <?php $role = strtolower(\App\Core\Auth::role() ?? ''); ?>

            <p class="px-3 mb-3 text-xs font-semibold text-gray-400 uppercase tracking-wider">Overzicht</p>
            
            <a href="<?= url('/portaal') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg <?= (\App\Core\View::isActive('/portaal')) ? 'bg-groen-50 text-groen-700' : 'text-gray-600 hover:bg-gray-50' ?>">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                Dashboard
            </a>
            
            <a href="<?= url('/portaal/profiel') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                Mijn profiel
            </a>

            <?php // ========== CONTROLEUR MENU ========== ?>
            <?php if ($role === 'commissielid'): ?>
            <p class="px-3 mt-6 mb-3 text-xs font-semibold text-gray-400 uppercase tracking-wider">Tuincontrole</p>

            <a href="<?= url('/portaal/inspecties/start') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                Inspectie starten
            </a>

            <a href="<?= url('/portaal/inspecties') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/></svg>
                Mijn inspecties
            </a>
            <?php endif; ?>

            <?php // ========== ADMIN/BESTUUR MENU ========== ?>
            <?php if (in_array($role, ['superuser', 'bestuur', 'penningmeester', 'pagina_beheer'])): ?>
            <p class="px-3 mt-6 mb-3 text-xs font-semibold text-gray-400 uppercase tracking-wider">Beheer</p>

            <a href="<?= url('/admin') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-blue-600 bg-blue-50 hover:bg-blue-100">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.066 2.573c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.573 1.066c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.066-2.573c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                Beheerpaneel →
            </a>
            <?php endif; ?>

            <?php // ========== PORTAAL MENU (iedereen behalve commissielid) ========== ?>
            <?php if ($role !== 'commissielid'): ?>
            <p class="px-3 mt-6 mb-3 text-xs font-semibold text-gray-400 uppercase tracking-wider">Mijn tuin</p>

            <a href="<?= url('/portaal/mijn-dossier') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
                Mijn tuindossier
            </a>

            <a href="<?= url('/portaal/meterstanden') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/></svg>
                Meterstanden
            </a>

            <p class="px-3 mt-6 mb-3 text-xs font-semibold text-gray-400 uppercase tracking-wider">Aanvragen</p>

            <a href="<?= url('/portaal/meldingen') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"/></svg>
                Meldingen
            </a>

            <a href="<?= url('/portaal/vergunningen') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                Vergunningen
            </a>

            <p class="px-3 mt-6 mb-3 text-xs font-semibold text-gray-400 uppercase tracking-wider">Overig</p>
            
            <a href="<?= url('/portaal/betalingen') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/></svg>
                Betalingen
            </a>

            <a href="<?= url('/portaal/documenten') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/></svg>
                Documenten
            </a>

            <a href="<?= url('/portaal/activiteiten') ?>" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-lg text-gray-600 hover:bg-gray-50">
                <svg class="w-5 h-5 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                Activiteiten
            </a>
            <?php endif; ?>
        </nav>
    </aside>

    <!-- Sidebar overlay (mobile) -->
    <div x-show="sidebarOpen" x-cloak @click="sidebarOpen = false"
         class="fixed inset-0 bg-black/30 z-10 lg:hidden"></div>

    <!-- Main content area -->
    <div class="lg:ml-64 pt-16">
        <!-- Flash Messages -->
        <?php foreach (['success' => 'green', 'error' => 'red', 'warning' => 'yellow', 'info' => 'blue'] as $type => $color): ?>
            <?php if (!empty($flash[$type])): ?>
            <div class="mx-4 sm:mx-6 mt-4" x-data="{ show: true }" x-show="show" x-transition
                 x-init="setTimeout(() => show = false, 5000)">
                <div class="rounded-lg bg-<?= $color ?>-50 border border-<?= $color ?>-200 p-4 flex justify-between items-center">
                    <p class="text-sm text-<?= $color ?>-800"><?= e($flash[$type]) ?></p>
                    <button @click="show = false" class="text-<?= $color ?>-500 hover:text-<?= $color ?>-700">
                        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
                    </button>
                </div>
            </div>
            <?php endif; ?>
        <?php endforeach; ?>

        <div class="p-4 sm:p-6 lg:p-8">
            <?= $content ?>
        </div>
    </div>

</body>
</html>
