<?php

use App\Core\Router;
use App\Controllers\PageController;
use App\Controllers\AuthController;
use App\Controllers\PortalController;
use App\Controllers\AdminController;
use App\Controllers\MemberController;

$router = new Router();

// ============================================================
// PUBLIEKE ROUTES
// ============================================================
$router->get('/',                   [PageController::class, 'home']);
$router->get('/over-ons',           [PageController::class, 'overOns']);
$router->get('/bestuur',            [PageController::class, 'bestuur']);
$router->get('/commissies',         [PageController::class, 'commissies']);
$router->get('/faciliteiten',       [PageController::class, 'faciliteiten']);
$router->get('/plattegrond',        [PageController::class, 'plattegrond']);
$router->get('/beschikbare-tuinen', [PageController::class, 'beschikbareTuinen']);
$router->get('/contact',            [PageController::class, 'contact']);
$router->get('/ik-wil-een-tuin',    [PageController::class, 'aspirantInfo']);

// ============================================================
// AUTHENTICATIE
// ============================================================
$router->get('/login',              [AuthController::class, 'showLogin']);
$router->post('/login',             [AuthController::class, 'login']);
$router->get('/logout',             [AuthController::class, 'logout']);
$router->get('/wachtwoord-vergeten',  [AuthController::class, 'showForgotPassword']);
$router->post('/wachtwoord-vergeten', [AuthController::class, 'forgotPassword']);

// ============================================================
// LEDENPORTAAL (Beveiligd)
// ============================================================
$router->get('/portaal',            [PortalController::class, 'dashboard'], ['AuthMiddleware']);

// ============================================================
// ADMIN / BEHEERPANEEL (Beveiligd)
// ============================================================
$router->get('/admin',                          [AdminController::class, 'dashboard'], ['AdminMiddleware']);
$router->get('/admin/paginas',                  [AdminController::class, 'pages'], ['AdminMiddleware']);
$router->get('/admin/paginas/{slug}',           [AdminController::class, 'editPage'], ['AdminMiddleware']);
$router->post('/admin/paginas/{slug}',          [AdminController::class, 'savePage'], ['AdminMiddleware']);
$router->get('/admin/media',                    [AdminController::class, 'media'], ['AdminMiddleware']);
$router->post('/admin/media/upload',            [AdminController::class, 'uploadMedia'], ['AdminMiddleware']);
$router->post('/admin/media/{id}/delete',       [AdminController::class, 'deleteMedia'], ['AdminMiddleware']);
$router->get('/admin/media/json',               [AdminController::class, 'mediaJson'], ['AdminMiddleware']);
$router->get('/admin/menu',                     [AdminController::class, 'menu'], ['AdminMiddleware']);
$router->post('/admin/menu/save',               [AdminController::class, 'saveMenuItem'], ['AdminMiddleware']);
$router->post('/admin/menu/{id}/delete',        [AdminController::class, 'deleteMenuItem'], ['AdminMiddleware']);
$router->post('/admin/menu/order',              [AdminController::class, 'saveMenuOrder'], ['AdminMiddleware']);
$router->get('/admin/instellingen',             [AdminController::class, 'settings'], ['AdminMiddleware']);
$router->post('/admin/instellingen',            [AdminController::class, 'saveSettings'], ['AdminMiddleware']);

// Ledenbeheer
$router->get('/admin/leden',                    [MemberController::class, 'index'], ['AdminMiddleware']);
$router->get('/admin/leden/nieuw',              [MemberController::class, 'create'], ['AdminMiddleware']);
$router->post('/admin/leden',                   [MemberController::class, 'store'], ['AdminMiddleware']);
$router->get('/admin/leden/{id}',               [MemberController::class, 'show'], ['AdminMiddleware']);
$router->get('/admin/leden/{id}/bewerk',        [MemberController::class, 'edit'], ['AdminMiddleware']);
$router->post('/admin/leden/{id}',              [MemberController::class, 'update'], ['AdminMiddleware']);
$router->post('/admin/leden/{id}/deactiveer',   [MemberController::class, 'deactivate'], ['AdminMiddleware']);
$router->post('/admin/leden/{id}/activeer',     [MemberController::class, 'activateUser'], ['AdminMiddleware']);

// Tuinbeheer
$router->get('/admin/tuinen',                   [MemberController::class, 'tuinen'], ['AdminMiddleware']);
$router->get('/admin/tuinen/nieuw',             [MemberController::class, 'tuinForm'], ['AdminMiddleware']);
$router->get('/admin/tuinen/{id}',              [MemberController::class, 'tuinForm'], ['AdminMiddleware']);
$router->post('/admin/tuinen/save',             [MemberController::class, 'tuinSave'], ['AdminMiddleware']);
$router->post('/admin/tuinen/{id}/delete',      [MemberController::class, 'tuinDelete'], ['AdminMiddleware']);

return $router;
