<?php
// Haal bewerkbare content op
$heroTitel = $content['hero_titel']['inhoud'] ?? 'Welkom bij VTV De Beukhoeve';
$heroSubtitel = $content['hero_subtitel']['inhoud'] ?? 'Al jaren een groene oase in de stad. Ontdek onze gemeenschap, wordt lid en geniet van uw eigen volkstuin.';
$heroAfbeelding = $content['hero_afbeelding']['afbeelding_pad'] ?? '';
$bodyContent = $content['body']['inhoud'] ?? '';
?>

<!-- Hero Section -->
<section class="relative text-white overflow-hidden">
    <?php if ($heroAfbeelding): ?>
    <!-- Hero met achtergrondafbeelding -->
    <div class="absolute inset-0">
        <img src="<?= url('/storage/uploads/media/' . $heroAfbeelding) ?>" alt="" class="w-full h-full object-cover">
        <div class="absolute inset-0 bg-groen-900/70"></div>
    </div>
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 lg:py-32">
    <?php else: ?>
    <!-- Hero zonder afbeelding (gradient) -->
    <div class="bg-gradient-to-br from-groen-700 via-groen-800 to-groen-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 lg:py-28">
    <?php endif; ?>
        <div class="max-w-3xl">
            <h1 class="text-4xl lg:text-5xl font-bold leading-tight mb-6">
                <?= e($heroTitel) ?>
            </h1>
            <p class="text-lg text-groen-100 mb-8 leading-relaxed">
                <?= e($heroSubtitel) ?>
            </p>
            <div class="flex flex-wrap gap-4">
                <a href="<?= url('/ik-wil-een-tuin') ?>" class="inline-flex items-center px-6 py-3 bg-white text-groen-800 font-semibold rounded-lg hover:bg-groen-50 transition shadow-lg">
                    🌱 Ik wil een tuin
                </a>
                <a href="<?= url('/over-ons') ?>" class="inline-flex items-center px-6 py-3 border-2 border-groen-300 text-groen-100 font-semibold rounded-lg hover:bg-white/10 transition">
                    Meer over ons →
                </a>
            </div>
        </div>
    </div>
    <?php if (!$heroAfbeelding): ?>
    </div>
    <?php endif; ?>
</section>

<!-- Quick Stats -->
<?php if ($beschikbare_tuinen > 0): ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 -mt-8 relative z-10">
    <div class="bg-white rounded-xl shadow-lg border border-gray-100 p-6 flex flex-col sm:flex-row items-center justify-between gap-4">
        <div class="flex items-center space-x-3">
            <div class="w-12 h-12 bg-groen-100 rounded-full flex items-center justify-center">
                <span class="text-2xl">🌿</span>
            </div>
            <div>
                <p class="text-2xl font-bold text-groen-700"><?= (int)$beschikbare_tuinen ?></p>
                <p class="text-sm text-gray-500">tuinen beschikbaar</p>
            </div>
        </div>
        <a href="<?= url('/beschikbare-tuinen') ?>" class="text-groen-600 hover:text-groen-700 font-medium text-sm">
            Bekijk beschikbare tuinen →
        </a>
    </div>
</div>
<?php endif; ?>

<!-- Bewerkbare body content -->
<?php if ($bodyContent): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-12">
    <div class="prose prose-lg max-w-none">
        <?= $bodyContent ?>
    </div>
</section>
<?php endif; ?>

<!-- Bulletins -->
<?php if (!empty($bulletins)): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-12">
    <h2 class="text-2xl font-bold text-gray-900 mb-6">Mededelingen</h2>
    <div class="space-y-4">
        <?php foreach ($bulletins as $bulletin): ?>
        <div class="bg-white rounded-lg shadow-sm border-l-4 p-5 
            <?php if ($bulletin['type'] === 'belangrijk'): ?>border-red-500<?php elseif ($bulletin['type'] === 'waarschuwing'): ?>border-yellow-500<?php else: ?>border-groen-500<?php endif; ?>">
            <div class="flex justify-between items-start">
                <div>
                    <h3 class="font-semibold text-gray-900"><?= e($bulletin['titel']) ?></h3>
                    <p class="text-gray-600 mt-1 text-sm"><?= nl2br(e($bulletin['inhoud'])) ?></p>
                </div>
                <span class="text-xs text-gray-400 whitespace-nowrap ml-4">
                    <?= date('d-m-Y', strtotime($bulletin['created_at'])) ?>
                </span>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</section>
<?php endif; ?>

<!-- Upcoming Activities -->
<?php if (!empty($activiteiten)): ?>
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-12">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold text-gray-900">Agenda</h2>
        <a href="<?= url('/portaal/activiteiten') ?>" class="text-groen-600 hover:text-groen-700 text-sm font-medium">Alle activiteiten →</a>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php foreach ($activiteiten as $activiteit): ?>
        <div class="bg-white rounded-lg shadow-sm border border-gray-100 p-5 hover:shadow-md transition">
            <div class="flex items-start space-x-4">
                <div class="bg-groen-50 rounded-lg p-3 text-center min-w-[60px]">
                    <span class="text-2xl font-bold text-groen-700"><?= date('d', strtotime($activiteit['datum'])) ?></span>
                    <p class="text-xs text-groen-600 uppercase"><?= date('M', strtotime($activiteit['datum'])) ?></p>
                </div>
                <div>
                    <h3 class="font-semibold text-gray-900"><?= e($activiteit['titel']) ?></h3>
                    <p class="text-sm text-gray-500 mt-1"><?= date('H:i', strtotime($activiteit['datum'])) ?> uur</p>
                    <?php if ($activiteit['locatie']): ?>
                    <p class="text-sm text-gray-400 mt-1">📍 <?= e($activiteit['locatie']) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</section>
<?php endif; ?>

<!-- Quick Links -->
<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-12 mb-12">
    <h2 class="text-2xl font-bold text-gray-900 mb-6">Snelkoppelingen</h2>
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
        <a href="<?= url('/ik-wil-een-tuin') ?>" class="bg-white rounded-lg shadow-sm border border-gray-100 p-6 text-center hover:shadow-md hover:border-groen-200 transition group">
            <span class="text-3xl block mb-3">🌱</span>
            <span class="text-sm font-medium text-gray-700 group-hover:text-groen-700">Aspirant worden</span>
        </a>
        <a href="<?= url('/plattegrond') ?>" class="bg-white rounded-lg shadow-sm border border-gray-100 p-6 text-center hover:shadow-md hover:border-groen-200 transition group">
            <span class="text-3xl block mb-3">🗺️</span>
            <span class="text-sm font-medium text-gray-700 group-hover:text-groen-700">Plattegrond</span>
        </a>
        <a href="<?= url('/login') ?>" class="bg-white rounded-lg shadow-sm border border-gray-100 p-6 text-center hover:shadow-md hover:border-groen-200 transition group">
            <span class="text-3xl block mb-3">🔐</span>
            <span class="text-sm font-medium text-gray-700 group-hover:text-groen-700">Ledenportaal</span>
        </a>
        <a href="<?= url('/contact') ?>" class="bg-white rounded-lg shadow-sm border border-gray-100 p-6 text-center hover:shadow-md hover:border-groen-200 transition group">
            <span class="text-3xl block mb-3">📬</span>
            <span class="text-sm font-medium text-gray-700 group-hover:text-groen-700">Contact</span>
        </a>
    </div>
</section>
