<?php
/**
 * VTV De Beukhoeve - Root Bootstrap
 * 
 * Dit bestand vangt alle requests op en stuurt ze
 * door naar public/index.php. Werkt ook zonder .htaccess.
 */

// Stel het werkdirectory in op public/
$publicDir = __DIR__ . '/public';

// Als er een specifiek bestand in public/ gevraagd wordt (CSS, JS, images)
$requestUri = $_SERVER['REQUEST_URI'] ?? '';
$path = parse_url($requestUri, PHP_URL_PATH);

// Strip de base directory uit het pad
$scriptDir = dirname($_SERVER['SCRIPT_NAME']);
$relativePath = $path;
if ($scriptDir !== '/' && str_starts_with($path, $scriptDir)) {
    $relativePath = substr($path, strlen($scriptDir));
}
$relativePath = ltrim($relativePath, '/');

// Check of het een bestaand bestand is in public/ (assets etc.)
if ($relativePath && $relativePath !== 'index.php') {
    $publicFile = $publicDir . '/' . $relativePath;
    if (is_file($publicFile)) {
        // Bepaal MIME type
        $ext = pathinfo($publicFile, PATHINFO_EXTENSION);
        $mimeTypes = [
            'css' => 'text/css',
            'js' => 'application/javascript',
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'gif' => 'image/gif',
            'svg' => 'image/svg+xml',
            'ico' => 'image/x-icon',
            'woff' => 'font/woff',
            'woff2' => 'font/woff2',
        ];
        if (isset($mimeTypes[$ext])) {
            header('Content-Type: ' . $mimeTypes[$ext]);
            readfile($publicFile);
            exit;
        }
    }
}

// Blokkeer directe toegang tot gevoelige mappen
$blocked = ['app/', 'config/', 'database/', 'storage/', 'vendor/'];
foreach ($blocked as $dir) {
    if (str_starts_with($relativePath, $dir)) {
        http_response_code(403);
        die('Toegang geweigerd.');
    }
}

// Blokkeer gevoelige bestanden
if (preg_match('/\.(env|sql|sh|log)$/i', $relativePath)) {
    http_response_code(403);
    die('Toegang geweigerd.');
}

// Laad de front controller
require $publicDir . '/index.php';
