<?php

use App\Core\Router;
use App\Controllers\PageController;
use App\Controllers\AuthController;
use App\Controllers\PortalController;
use App\Controllers\AdminController;

$router = new Router();

// ============================================================
// PUBLIEKE ROUTES
// ============================================================
$router->get('/',                   [PageController::class, 'home']);
$router->get('/over-ons',           [PageController::class, 'overOns']);
$router->get('/bestuur',            [PageController::class, 'bestuur']);
$router->get('/commissies',         [PageController::class, 'commissies']);
$router->get('/faciliteiten',       [PageController::class, 'faciliteiten']);
$router->get('/plattegrond',        [PageController::class, 'plattegrond']);
$router->get('/beschikbare-tuinen', [PageController::class, 'beschikbareTuinen']);
$router->get('/contact',            [PageController::class, 'contact']);
$router->get('/ik-wil-een-tuin',    [PageController::class, 'aspirantInfo']);

// ============================================================
// AUTHENTICATIE
// ============================================================
$router->get('/login',              [AuthController::class, 'showLogin']);
$router->post('/login',             [AuthController::class, 'login']);
$router->get('/logout',             [AuthController::class, 'logout']);
$router->get('/wachtwoord-vergeten',  [AuthController::class, 'showForgotPassword']);
$router->post('/wachtwoord-vergeten', [AuthController::class, 'forgotPassword']);

// ============================================================
// LEDENPORTAAL (Beveiligd)
// ============================================================
$router->get('/portaal',            [PortalController::class, 'dashboard'], ['AuthMiddleware']);

// ============================================================
// ADMIN / BEHEERPANEEL (Beveiligd)
// ============================================================
$router->get('/admin',                          [AdminController::class, 'dashboard'], ['AdminMiddleware']);
$router->get('/admin/paginas',                  [AdminController::class, 'pages'], ['AdminMiddleware']);
$router->get('/admin/paginas/{slug}',           [AdminController::class, 'editPage'], ['AdminMiddleware']);
$router->post('/admin/paginas/{slug}',          [AdminController::class, 'savePage'], ['AdminMiddleware']);
$router->get('/admin/media',                    [AdminController::class, 'media'], ['AdminMiddleware']);
$router->post('/admin/media/upload',            [AdminController::class, 'uploadMedia'], ['AdminMiddleware']);
$router->post('/admin/media/{id}/delete',       [AdminController::class, 'deleteMedia'], ['AdminMiddleware']);
$router->get('/admin/media/json',               [AdminController::class, 'mediaJson'], ['AdminMiddleware']);
$router->get('/admin/menu',                     [AdminController::class, 'menu'], ['AdminMiddleware']);
$router->post('/admin/menu/save',               [AdminController::class, 'saveMenuItem'], ['AdminMiddleware']);
$router->post('/admin/menu/{id}/delete',        [AdminController::class, 'deleteMenuItem'], ['AdminMiddleware']);
$router->post('/admin/menu/order',              [AdminController::class, 'saveMenuOrder'], ['AdminMiddleware']);
$router->get('/admin/instellingen',             [AdminController::class, 'settings'], ['AdminMiddleware']);
$router->post('/admin/instellingen',            [AdminController::class, 'saveSettings'], ['AdminMiddleware']);

return $router;
