<div class="flex items-center justify-between mb-6">
    <div class="flex items-center space-x-3">
        <a href="<?= url('/admin/paginas') ?>" class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg">
            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
        </a>
        <div>
            <h1 class="text-2xl font-bold text-gray-900"><?= e($pageLabel) ?></h1>
            <p class="text-sm text-gray-500">/<?= e($slug === 'home' ? '' : $slug) ?></p>
        </div>
    </div>
    <a href="<?= url('/' . ($slug === 'home' ? '' : $slug)) ?>" target="_blank" class="text-sm text-groen-600 hover:text-groen-700 flex items-center space-x-1">
        <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/></svg>
        <span>Bekijk pagina</span>
    </a>
</div>

<form method="POST" action="<?= url('/admin/paginas/' . $slug) ?>" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <?php
    // Groepeer secties
    $sectionData = [];
    foreach ($sections as $s) {
        $sectionData[$s['sectie']] = $s;
    }

    // Homepage heeft speciale secties
    if ($slug === 'home'):
    ?>
    <!-- Hero sectie -->
    <div class="bg-white rounded-xl border border-gray-200 mb-6">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900">Hero sectie</h2>
            <p class="text-sm text-gray-500">Het eerste wat bezoekers zien</p>
        </div>
        <div class="p-6 space-y-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Hero titel</label>
                <input type="text" name="secties[hero_titel]" 
                       value="<?= e($sectionData['hero_titel']['inhoud'] ?? 'Welkom bij VTV De Beukhoeve') ?>"
                       class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 focus:border-groen-500 outline-none">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Hero subtitel</label>
                <textarea name="secties[hero_subtitel]" rows="2"
                          class="w-full px-4 py-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-groen-500 focus:border-groen-500 outline-none"><?= e($sectionData['hero_subtitel']['inhoud'] ?? '') ?></textarea>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Hero achtergrondafbeelding</label>
                <?php if (!empty($sectionData['hero_afbeelding']['afbeelding_pad'])): ?>
                <div class="mb-2">
                    <img src="<?= url('/storage/uploads/media/' . $sectionData['hero_afbeelding']['afbeelding_pad']) ?>" 
                         alt="Hero" class="h-32 rounded-lg object-cover">
                </div>
                <?php endif; ?>
                <input type="file" name="afbeeldingen[hero_afbeelding]" accept="image/*"
                       class="text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-groen-50 file:text-groen-700 hover:file:bg-groen-100">
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Body content -->
    <div class="bg-white rounded-xl border border-gray-200 mb-6">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900">Pagina inhoud</h2>
        </div>
        <div class="p-6">
            <textarea name="secties[body]" id="editor-body" class="tinymce-editor"><?= $sectionData['body']['inhoud'] ?? '' ?></textarea>
        </div>
    </div>

    <!-- Pagina afbeelding -->
    <div class="bg-white rounded-xl border border-gray-200 mb-6">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50 rounded-t-xl">
            <h2 class="font-semibold text-gray-900">Pagina afbeelding</h2>
            <p class="text-sm text-gray-500">Optionele afbeelding bij deze pagina</p>
        </div>
        <div class="p-6">
            <?php if (!empty($sectionData['body']['afbeelding_pad'])): ?>
            <div class="mb-3">
                <img src="<?= url('/storage/uploads/media/' . $sectionData['body']['afbeelding_pad']) ?>" 
                     alt="" class="h-40 rounded-lg object-cover">
            </div>
            <?php endif; ?>
            <input type="file" name="afbeeldingen[body]" accept="image/*"
                   class="text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-groen-50 file:text-groen-700 hover:file:bg-groen-100">
        </div>
    </div>

    <!-- Opslaan -->
    <div class="flex items-center justify-between">
        <a href="<?= url('/admin/paginas') ?>" class="px-4 py-2.5 text-sm text-gray-600 hover:text-gray-800">Annuleren</a>
        <button type="submit" class="px-6 py-2.5 bg-groen-600 text-white text-sm font-medium rounded-lg hover:bg-groen-700 transition">
            Opslaan
        </button>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    tinymce.init({
        selector: '.tinymce-editor',
        height: 500,
        language: 'nl',
        menubar: 'file edit view insert format',
        plugins: 'lists link image table code fullscreen preview media hr',
        toolbar: 'undo redo | blocks | bold italic underline strikethrough | forecolor backcolor | alignleft aligncenter alignright | bullist numlist | link image | table | code fullscreen',
        block_formats: 'Paragraaf=p; Kop 2=h2; Kop 3=h3; Kop 4=h4',
        content_style: 'body { font-family: system-ui, -apple-system, sans-serif; font-size: 15px; line-height: 1.6; color: #1f2937; max-width: 800px; margin: 0 auto; padding: 16px; }',
        image_list: '<?= url('/admin/media/json') ?>',
        file_picker_types: 'image',
        automatic_uploads: true,
        images_upload_url: '<?= url('/admin/media/upload') ?>',
        images_upload_handler: function(blobInfo, progress) {
            return new Promise(function(resolve, reject) {
                var formData = new FormData();
                formData.append('bestand', blobInfo.blob(), blobInfo.filename());
                formData.append('map', 'paginas');
                formData.append('_csrf_token', document.querySelector('input[name=_csrf_token]').value);
                
                var xhr = new XMLHttpRequest();
                xhr.open('POST', '<?= url('/admin/media/upload') ?>');
                xhr.onload = function() {
                    if (xhr.status === 200) {
                        var json = JSON.parse(xhr.responseText);
                        resolve(json.url);
                    } else {
                        reject('Upload mislukt: ' + xhr.status);
                    }
                };
                xhr.onerror = function() { reject('Upload mislukt.'); };
                xhr.send(formData);
            });
        },
        branding: false,
        promotion: false,
        license_key: 'gpl',
    });
});
</script>
