<?php

namespace App\Middleware;

use App\Core\Auth;
use App\Core\Session;
use App\Core\View;

class AdminMiddleware
{
    public function handle(): bool
    {
        if (!Auth::check()) {
            Session::flash('error', 'U moet ingelogd zijn.');
            $basePath = View::basePath();
            header('Location: ' . $basePath . '/login');
            exit;
        }

        $role = Auth::role();
        $allowedRoles = ['superuser', 'bestuur', 'penningmeester', 'pagina_beheer'];

        if (!in_array($role, $allowedRoles)) {
            Session::flash('error', 'U heeft geen toegang tot het beheerpaneel.');
            $basePath = View::basePath();
            header('Location: ' . $basePath . '/portaal');
            exit;
        }

        return true;
    }
}
