<?php
/**
 * VTV De Beukhoeve - Front Controller
 * All requests are routed through this file.
 */

// Error reporting based on environment
if (getenv('APP_DEBUG') === 'true') {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
} else {
    error_reporting(0);
    ini_set('display_errors', '0');
}

// Timezone
date_default_timezone_set('Europe/Amsterdam');

// Define base path
define('BASE_PATH', dirname(__DIR__));

// Autoloader (registered early so Env class can be loaded)

spl_autoload_register(function (string $class) {
    // Convert namespace to file path: App\Core\Database -> app/Core/Database.php
    $prefix = 'App\\';
    if (str_starts_with($class, $prefix)) {
        $relativeClass = substr($class, strlen($prefix));
        $file = BASE_PATH . '/app/' . str_replace('\\', '/', $relativeClass) . '.php';
        if (file_exists($file)) {
            require_once $file;
        }
    }
});

// Start session
use App\Core\Session;
use App\Helpers\Env;

// Load environment variables
Env::load(BASE_PATH);

// Redirect naar installer als nog niet geïnstalleerd
if (!getenv('INSTALLED') || getenv('INSTALLED') !== 'true') {
    $requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    
    // Detecteer base path
    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
    $basePath = ($scriptDir !== '/' && $scriptDir !== '\\') ? $scriptDir : '';
    
    $installUrl = $basePath . '/install.php';
    
    if (!str_contains($requestUri, 'install.php')) {
        if (file_exists(__DIR__ . '/install.php')) {
            header('Location: ' . $installUrl);
            exit;
        }
    }
    // Laat install.php zelf afhandelen
    if (str_contains($requestUri, 'install.php')) {
        require __DIR__ . '/install.php';
        exit;
    }
}

Session::start();

// Security headers
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

// Load and dispatch routes
$router = require BASE_PATH . '/config/routes.php';
$router->dispatch();
