<?php

use App\Core\Router;
use App\Controllers\PageController;
use App\Controllers\AuthController;
use App\Controllers\PortalController;

$router = new Router();

// ============================================================
// PUBLIEKE ROUTES
// ============================================================
$router->get('/',                   [PageController::class, 'home']);
$router->get('/over-ons',           [PageController::class, 'overOns']);
$router->get('/bestuur',            [PageController::class, 'bestuur']);
$router->get('/commissies',         [PageController::class, 'commissies']);
$router->get('/faciliteiten',       [PageController::class, 'faciliteiten']);
$router->get('/plattegrond',        [PageController::class, 'plattegrond']);
$router->get('/beschikbare-tuinen', [PageController::class, 'beschikbareTuinen']);
$router->get('/contact',            [PageController::class, 'contact']);
$router->get('/ik-wil-een-tuin',    [PageController::class, 'aspirantInfo']);

// ============================================================
// AUTHENTICATIE
// ============================================================
$router->get('/login',              [AuthController::class, 'showLogin']);
$router->post('/login',             [AuthController::class, 'login']);
$router->get('/logout',             [AuthController::class, 'logout']);
$router->get('/wachtwoord-vergeten',  [AuthController::class, 'showForgotPassword']);
$router->post('/wachtwoord-vergeten', [AuthController::class, 'forgotPassword']);

// ============================================================
// LEDENPORTAAL (Beveiligd)
// ============================================================
$router->get('/portaal',            [PortalController::class, 'dashboard'], ['AuthMiddleware']);

return $router;
