<section class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <h1 class="text-3xl font-bold text-gray-900 mb-2">Ik wil een tuin</h1>
    <p class="text-gray-500 mb-10 max-w-3xl">Interesse in een volkstuin bij VTV De Beukhoeve? Hier leest u hoe de procedure werkt.</p>

    <!-- Stappen -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 relative">
            <div class="w-10 h-10 bg-groen-600 text-white rounded-full flex items-center justify-center font-bold mb-4">1</div>
            <h3 class="font-semibold text-gray-900 mb-2">Aanmelden</h3>
            <p class="text-sm text-gray-600">Vul het aanmeldformulier in met uw basisgegevens. U ontvangt een bevestiging per e-mail.</p>
        </div>
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="w-10 h-10 bg-groen-600 text-white rounded-full flex items-center justify-center font-bold mb-4">2</div>
            <h3 class="font-semibold text-gray-900 mb-2">Beoordeling</h3>
            <p class="text-sm text-gray-600">Uw aanmelding wordt beoordeeld door de commissie en het bestuur. U kunt de status volgen.</p>
        </div>
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="w-10 h-10 bg-groen-600 text-white rounded-full flex items-center justify-center font-bold mb-4">3</div>
            <h3 class="font-semibold text-gray-900 mb-2">Welkom!</h3>
            <p class="text-sm text-gray-600">Na goedkeuring wordt u lid en ontvangt u toegang tot uw eigen volkstuin.</p>
        </div>
    </div>

    <!-- CTA -->
    <div class="bg-gradient-to-br from-groen-600 to-groen-800 rounded-2xl p-8 md:p-12 text-white text-center">
        <h2 class="text-2xl font-bold mb-4">Klaar om te beginnen?</h2>
        <p class="text-groen-100 mb-6 max-w-xl mx-auto">
            Meld u aan als aspirant-lid en zet de eerste stap naar uw eigen volkstuin.
        </p>
        <a href="<?= url('/aspirant/aanmelden') ?>" class="inline-flex items-center px-8 py-3 bg-white text-groen-700 font-semibold rounded-lg hover:bg-groen-50 transition shadow-lg">
            🌱 Nu aanmelden
        </a>
    </div>

    <!-- Veelgestelde vragen -->
    <div class="mt-12">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">Veelgestelde vragen</h2>
        <div class="space-y-4" x-data="{ open: null }">
            <div class="bg-white rounded-lg shadow-sm border border-gray-100">
                <button @click="open = open === 1 ? null : 1" class="w-full flex justify-between items-center px-6 py-4 text-left">
                    <span class="font-medium text-gray-900">Wat kost een volkstuin?</span>
                    <svg class="w-5 h-5 text-gray-400 transition-transform" :class="open === 1 && 'rotate-180'" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                </button>
                <div x-show="open === 1" x-cloak x-collapse class="px-6 pb-4 text-sm text-gray-600">
                    De jaarlijkse contributie bestaat uit het lidmaatschap en tuinhuur. Neem contact op voor de actuele tarieven.
                </div>
            </div>
            <div class="bg-white rounded-lg shadow-sm border border-gray-100">
                <button @click="open = open === 2 ? null : 2" class="w-full flex justify-between items-center px-6 py-4 text-left">
                    <span class="font-medium text-gray-900">Hoe lang duurt de procedure?</span>
                    <svg class="w-5 h-5 text-gray-400 transition-transform" :class="open === 2 && 'rotate-180'" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                </button>
                <div x-show="open === 2" x-cloak x-collapse class="px-6 pb-4 text-sm text-gray-600">
                    De beoordelingsprocedure duurt doorgaans enkele weken. De wachttijd voor een tuin is afhankelijk van de beschikbaarheid.
                </div>
            </div>
            <div class="bg-white rounded-lg shadow-sm border border-gray-100">
                <button @click="open = open === 3 ? null : 3" class="w-full flex justify-between items-center px-6 py-4 text-left">
                    <span class="font-medium text-gray-900">Zijn er verplichtingen als lid?</span>
                    <svg class="w-5 h-5 text-gray-400 transition-transform" :class="open === 3 && 'rotate-180'" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                </button>
                <div x-show="open === 3" x-cloak x-collapse class="px-6 pb-4 text-sm text-gray-600">
                    Ja, leden dienen hun tuin te onderhouden conform het reglement en werkbeurten te vervullen.
                </div>
            </div>
        </div>
    </div>
</section>
